'
' This program demonstrates the CD Audio interface
'

' $INCLUDE: 'SBC.BI'
' $INCLUDE: 'SBCSYS.BI'
' $INCLUDE: 'SBCD.BI'

DECLARE SUB SHOWMSG ()
DECLARE SUB SHOWTRACK ()
DECLARE FUNCTION LOBYTE% (num%)
DECLARE FUNCTION HIBYTE% (num%)
DECLARE FUNCTION LOWORD% (num&)
DECLARE FUNCTION HIWORD% (num&)
DECLARE FUNCTION BCD2BIN% (num%)
DECLARE FUNCTION HSG2RED& (num&)


CONST   SKIPSEC=16


REM $DYNAMIC
CLEAR

DIM  userkey AS INTEGER, drvnum AS INTEGER, quit AS INTEGER
DIM  dummy AS INTEGER

CLS

PRINT "SBK Basic CD Audio Interface Example"

quit = 0

IF  (CDINIT%(drvnum) = 0) THEN

    CALL SHOWMSG

    WHILE quit = 0

        CALL SHOWTRACK

        c$ = INKEY$

        IF c$ <> "" THEN
            userkey = ASC(c$)

            SELECT CASE userkey
                CASE ASC("P"), ASC("p")
                    dummy = CDPLAY%(1,0,&H0ffff)
                CASE ASC("S"), ASC("s")
                    dummy = CDSTOP%
                CASE ASC("A"), ASC("a")
                    dummy = CDPAUSE%
                CASE ASC("C"), ASC("c")
                    dummy = CDCONT%
                CASE ASC("N"), ASC("n")
                    dummy = CDNXTTRK%
                CASE ASC("L"), ASC("l")
                    dummy = CDPRVTRK%
                CASE ASC("F"), ASC("f")
                    dummy = CDFASTFWD%(SKIPSEC)
                CASE ASC("R"), ASC("r")
                    dummy = CDREWIND%(SKIPSEC)
                CASE ASC("Q"), ASC("q")
                    quit = 1
            END SELECT
        ENDIF
    WEND
ELSE
    PRINT "Initialization error."
ENDIF

END


' ------------------------------------------------------------------------ '

SUB  SHOWMSG

' This function shows the CD player control keys

    PRINT
    PRINT "Compact Disc Player Demo Program"
    PRINT
    PRINT TAB(5);"P  : Play"
    PRINT TAB(5);"S  : Stop"
    PRINT TAB(5);"A  : Pause"
    PRINT TAB(5);"C  : Continue"
    PRINT TAB(5);"N  : Next Track"
    PRINT TAB(5);"L  : Previous Track"
    PRINT TAB(5);"F  : Fast Forward"
    PRINT TAB(5);"R  : Rewind"
    PRINT TAB(5);"Q  : Quit"
END SUB


' ------------------------------------------------------------------------ '

REM %STATIC
SUB  SHOWTRACK

    DIM  qchinfo AS QCHANINFO, volume AS LONG, trkno AS INTEGER


    dummy = CDGETLOC%(qchinfo)
    dummy = CDGETVOL%(volume)
    volume = HSG2RED&((volume))
    trkno = ASC((qchinfo.tno))

    ' moves cursor to row 15 and column 1
    ' makes cursor invisible
    LOCATE  15,1,0
    PRINT USING "Disc - ###:##, Track - ## ##:##, Vol - ###:##";_
                ASC((qchinfo.pmin)); ASC((qchinfo.psec)); BCD2BIN%((trkno));_
                ASC((qchinfo.min)); ASC((qchinfo.sec));_
                LOBYTE%(HIWORD%((volume))); HIBYTE%(LOWORD%((volume)))

END SUB


' ------------------------------------------------------------------------ '

FUNCTION LOBYTE% (num%)

    ' returns the low byte of the data
    LOBYTE% = num% AND &H0ff

END FUNCTION


' ------------------------------------------------------------------------ '

FUNCTION HIBYTE% (num%)

    ' returns the high byte of the data
    HIBYTE% = num% \ &H0ff

END FUNCTION


' ------------------------------------------------------------------------ '

FUNCTION LOWORD% (num&)

    ' returns the low word of the data
    LOWORD% = num& AND &H0ffff&

END FUNCTION


' ------------------------------------------------------------------------ '

FUNCTION HIWORD% (num&)

    ' return the high word of the data
    HIWORD% = (num& \ &H0ffff&) AND &H0ffff&

END FUNCTION


' ------------------------------------------------------------------------ '

FUNCTION BCD2BIN% (num%)

    DIM num1 AS INTEGER, num2 AS INTEGER
    DIM num3 AS INTEGER


    ' convert BCD format to Binary format
    num1 = num% \ 16
    num2 = num% AND &H0f
    num3 = (num1 * 10) + num2
    BCD2BIN% = num3

END FUNCTION


' ------------------------------------------------------------------------ '

FUNCTION HSG2RED& (num&)

    DIM v3&, v2&, v1&, v0&


    ' convert from High Sierra format to Red Book format
    v2& = num& \ 4500
    v1& = (num& MOD 4500) \ 75
    v0& = (num& MOD 4500) MOD 75
    v3& = (v2& * &H10000&) + (v1& * &H100&) + v0&
    HSG2RED& = v3&

END FUNCTION
